#ifndef _ROUTINES_CPP
#define _ROUTINES_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"

#include "../SockServer/SockServer.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsSessionLogDir[MAX_PATH];
char sImportTempDir[MAX_PATH];
char gsAuthKey[MAX_AUTH_LENGTH];
char gsAuthString[MAX_AUTH_LENGTH];

char gsSQLCustDriver[255];
char gsSQLCustPassword[255];
char gsSQLCustServer[255];
char gsSQLCustUserID[255];

char gsSQLIndexDatabase[255];
char gsSQLIndexDriver[255];
char gsSQLIndexPassword[255];
char gsSQLIndexServer[255];
char gsSQLIndexUserID[255];

int giKeyGenLength = 0;
int giListenPort = 0;
int giMaxClients = 0;

FILE *gfhSessionLog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD iSizeofString = 0;

	iSizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthKey);
	memset(gsAuthKey, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey, iSizeofString))
        return false;
	
	iSizeofString = sizeof(sImportTempDir);
	memset(sImportTempDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ImportTempDir", sImportTempDir, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsSQLCustDriver);
	memset(gsSQLCustDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustDriver", gsSQLCustDriver, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustPassword);
	memset(gsSQLCustPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustPassword", gsSQLCustPassword, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustServer);
	memset(gsSQLCustServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustServer", gsSQLCustServer, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustUserID);
	memset(gsSQLCustUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustUserID", gsSQLCustUserID, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexDatabase);
	memset(gsSQLIndexDatabase, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDatabase", gsSQLIndexDatabase, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexDriver);
	memset(gsSQLIndexDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDriver", gsSQLIndexDriver, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexPassword);
	memset(gsSQLIndexPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexPassword", gsSQLIndexPassword, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexServer);
	memset(gsSQLIndexServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexServer", gsSQLIndexServer, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexUserID);
	memset(gsSQLIndexUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexUserID", gsSQLIndexUserID, iSizeofString))
        return false;


	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ListenPort", (DWORD &)giListenPort))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "MaxClients", (DWORD &)giMaxClients))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "KeyGenLength", (DWORD &)giKeyGenLength))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DropBadPackets", (DWORD &)gbDropBadPackets))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PacketMode", (DWORD &)gbPacketMode))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "NextClientID", (DWORD &)giNextClientID))
        return false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void)
{
	return true;
}	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char sFullPath[MAX_PATH];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(sFullPath, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfhSessionLog = fopen(sFullPath, "ab")) == NULL)
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseLogFile(void)
{
	if(gfhSessionLog)
	{
		fclose(gfhSessionLog);
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteSysLog(char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[2048];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [*] %s", lsDate, lsTime, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(int iClientId, char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[2048];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [%d] %s", lsDate, lsTime, iClientId, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbIsMainDialogOpen)
    {
        EndDialog(MainDialog_hWnd, 0);
    }

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CmdCmp(const char *sBuf, const char *sCmd)
{
	int iCmdLen = strlen(sCmd);
	if( strncmp(sBuf, sCmd, iCmdLen) == 0)
		return iCmdLen;
	else return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf)
{
	int iRPos = 0;
	int iRWos = strlen(sCmd);

	strcpy(sOutBuf, sCmd);

	while(iRPos < iDataSz)
		sOutBuf[iRWos++] = sData[iRPos++];

	return iRWos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf)
{
	int WPos = 0;
	int RPos = iCmdLen;

	while(RPos < iBufSz)
		sOutBuf[WPos++] = sBuf[RPos++];

	sOutBuf[WPos] = '\0';

	return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *sFullPath)
{
    char Directory[MAX_PATH];

    int NameLength = strlen(sFullPath);
    int Position = 0;

    while(Position < NameLength)
    {
        if(sFullPath[Position] == '\\' || sFullPath[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = sFullPath[Position];

        Position++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif
